/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is wxFacePlayer
 *
 * The Initial Developer of the Original Code is
 * ITC-irst, TCC Division (http://tcc.fbk.eu) Trento / ITALY.
 * Portions created by the Initial Developer are Copyright (C) 2004 - 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * - Koray Balci (koraybalci@gmail.com)
 * ***** END LICENSE BLOCK ***** */

#include <wx/wx.h>
#include <wx/image.h>
#include <wx/filename.h>
#include <wx/bmpbuttn.h>
#include <wx/tglbtn.h>
#include <wx/slider.h>
#include <wx/statline.h>
#include <wx/textdlg.h>
#include <wx/colordlg.h>
#include <wx/config.h>


#include "toggle.h"
#include "ConnPortSetting.h"
#include "wxFacePlayerApp.h"
#include "wxFacePlayerFrm.h"
#include "DropFAPFileTarget.h"
//#include "DictionaryFilesDlg.h"


// ----------------------------------------------------------------------------
// event tables and other macros for wxWindows
// ----------------------------------------------------------------------------

// the event tables connect the wxWindows events with the functions (event
// handlers) which process them. It can be also done at run-time, but for the
// simple menu events like this the static method is much simpler.
IMPLEMENT_CLASS(wxFacePlayerFrame, wxFrame)
BEGIN_EVENT_TABLE(wxFacePlayerFrame, wxFrame)
	EVT_MENU(Quit,  wxFacePlayerFrame::OnQuit)
	EVT_MENU(About_Menu, wxFacePlayerFrame::OnAbout)
	EVT_MENU(Open_FDP, wxFacePlayerFrame::OnOpenFDP)
	EVT_TOGGLEBUTTON(Sound_On, wxFacePlayerFrame::OnSoundOn)
	EVT_TOGGLEBUTTON(Listen_TCP, wxFacePlayerFrame::OnServerMode)
	EVT_MENU(Save_AVI, wxFacePlayerFrame::OnSaveAVI)
	EVT_MENU(Settings_Port, wxFacePlayerFrame::OnPortSettings)
	EVT_BUTTON(Save_AVI, wxFacePlayerFrame::OnSaveAVI)
	EVT_BUTTON(Start_Playback, wxFacePlayerFrame::OnStartPlayback)
	EVT_BUTTON(Stop_Playback, wxFacePlayerFrame::OnStopPlayback)
	EVT_BUTTON(Open_FapWav, wxFacePlayerFrame::OnOpenPair)
	EVT_MENU(Open_FapWav, wxFacePlayerFrame::OnOpenPair)
	EVT_BUTTON(Save_FapWav, wxFacePlayerFrame::OnSavePair)
	EVT_MENU(Save_FapWav, wxFacePlayerFrame::OnSavePair)
	EVT_MENU(Background_Color, wxFacePlayerFrame::OnBackgroundColor)
	EVT_COMMAND_SCROLL(Fap_Slider, wxFacePlayerFrame::OnSlider) 
END_EVENT_TABLE()

// ----------------------------------------------------------------------------
// main frame
// ----------------------------------------------------------------------------

// frame constructor
wxFacePlayerFrame::wxFacePlayerFrame(const wxString& title, const wxPoint& pos, const wxSize& size, long style)
: wxFrame((wxFrame *)NULL, -1, title, pos, size, style), m_pFaceView(0)
{
	wxImage::AddHandler(new wxPNGHandler());
	// set the frame icon
#ifdef WIN32
	SetIcon(wxICON(wxFacePlayer));
#endif

	wxConfigBase *pConfig = wxConfigBase::Get();
	wxString statusText;
	pConfig->Read(_T("Window/StatusText"), &statusText, _T("XfacePlayer by ITC-irst"));

	wxPanel *panel = new wxPanel(this, -1);
	wxBoxSizer *topsizer = new wxBoxSizer( wxVERTICAL );

	wxSlider* pSlider = 0;

	try
	{
		// Create OpenGL window for the Face
		m_pFaceView = new FaceView(panel, this, pSlider, 1001, wxPoint(-1, -1), /*wxSize(400, 400)*/size);
		topsizer->Add(
		m_pFaceView,
		1,            // make vertically stretchable
		wxEXPAND);         // set border width to 10
	}
	catch(...)
	{
		wxMessageBox(_T("Unable to create OpenGL window, you might have a problem with your video card drivers"), _T("Exception"));
		Close(true);
	}
	
//	SetSizer( topsizer );      // use the sizer for layout
	panel->SetSizer( topsizer );
    panel->SetAutoLayout( TRUE );

	topsizer->SetSizeHints( this );   // set size hints to honour minimum size

	// create a status bar
	CreateStatusBar(2);
	this->GetStatusBar()->Hide();
	this->SetWindowStyle(2);
	SetDropTarget(new DropFAPFileTarget(this));

	m_pFaceView->serverMode(true);
}

// frame destructor
wxFacePlayerFrame::~wxFacePlayerFrame()
{
//	delete m_pFaceView;
}

// event handlers
void wxFacePlayerFrame::OnQuit(wxCommandEvent& event)
{
	// TRUE is to force the frame to close
	Close(TRUE);
}

void wxFacePlayerFrame::OnAbout(wxCommandEvent& event)
{
	// called when help - about is picked from the menu or toolbar
	wxString msg;
	msg.Printf(_("About XfacePlayer..."));
	wxMessageBox(_("XfacePlayer by FBK-irst.\nVersion 1.0"), msg, wxOK | wxICON_INFORMATION, this);
}

void wxFacePlayerFrame::SetFAP(const wxString& filename)
{
	m_pFaceView->setInitialFap((const char*)filename.c_str());
}

void wxFacePlayerFrame::SetFDP(const wxString& filename, const wxString& path)
{
	m_pFaceView->setInitialFdp((const char*)filename.c_str(), (const char*)path.c_str());
}

void wxFacePlayerFrame::SetWAV(const wxString& filename)
{
	m_pFaceView->setInitialWav((const char*)filename.c_str());
}

void wxFacePlayerFrame::LoadFAP(const wxString& filename) const
{
	m_pFaceView->loadFAP((const char*)filename.c_str());
}

void wxFacePlayerFrame::LoadWAV(const wxString& filename) const
{
	m_pFaceView->loadWAV((const char*)filename.c_str());
}

void wxFacePlayerFrame::OnSavePair(wxCommandEvent& event)
{
	wxFileDialog dlgFap(this, _T("Save FAP file..."), wxEmptyString, wxEmptyString, _T("FAP files (*.fap)|*.fap"),
		wxSAVE | wxOVERWRITE_PROMPT);
	wxFileDialog dlgWav(this, _T("Save WAV file..."), wxEmptyString, wxEmptyString, _T("WAV files (*.wav)|*.wav"),
		wxSAVE | wxOVERWRITE_PROMPT);
	if(dlgFap.ShowModal() == wxID_OK)
	{
		// save fap
		m_pFaceView->saveFAP((const char*)dlgFap.GetPath().c_str());
		// change the extension from fap to wav for new dlg
		wxFileName filename(dlgFap.GetPath());
		filename.SetExt(_T("wav"));
		dlgWav.SetFilename(filename.GetFullPath());
	}
	// save wav
	if(dlgWav.ShowModal() == wxID_OK)
		m_pFaceView->saveWAV((const char*) dlgWav.GetPath().c_str());
}

void wxFacePlayerFrame::OnOpenPair(wxCommandEvent& event)
{
	wxFileDialog dlg(this, _T("Load SMIL-Agent / FAP / PHO file..."), wxEmptyString, wxEmptyString, _T("SMIL-Agent files (*.smil)|*.smil|FAP files (*.fap)|*.fap|Phoneme files (*.pho)|*.pho"),
		wxOPEN | wxFILE_MUST_EXIST);
	wxFileDialog dlg2(this, _T("Load WAV file..."), wxEmptyString, wxEmptyString, _T("WAV files (*.wav)|*.wav"),
		wxOPEN | wxFILE_MUST_EXIST);

	if(dlg.ShowModal() == wxID_OK)
	{
		switch(dlg.GetFilterIndex())
		{
		case 1:		// Load the Fap file
			LoadFAP(dlg.GetPath());
			break;
		case 2:		// Load the Phoneme file
			{
				wxTextEntryDialog langDlg(this, _T("Enter phoneme language\nas it is in the matching dictionary file\neg: \"english\" for SAPI5.1 English (as in en_SAPI.dic file)"), _T("Enter language"));
			if(langDlg.ShowModal() == wxID_OK)
				m_pFaceView->loadPHO((const char*)dlg.GetPath().c_str(), (const char*)langDlg.GetValue().c_str());
			}
			break;

		case 0:		// Load Smil file
			m_pFaceView->loadSMILScript((const char*)dlg.GetPath().c_str());
			break;
		}
		

		if(dlg.GetFilterIndex() > 0)
		{
			// Try to get a filename for wav
			if(dlg2.ShowModal() == wxID_OK)
				LoadWAV(dlg2.GetPath());
			else	// if no name provided, try to match one with the same filename + wav extension
			{
				// try to load 
				wxString wavname = dlg.GetFilename();
				if(wavname.Replace(_T(".fap"), _T(".wav")) == 1) // else there is a problem!
					LoadWAV((dlg.GetDirectory() + wavname));
			}
		}
	}	
}

void wxFacePlayerFrame::OnOpenFDP(wxCommandEvent& event)
{
	wxFileDialog dlg(this, _T("Load FDP file"), wxEmptyString, wxEmptyString, _T("FDP files (*.fdp)|*.fdp"),
		wxOPEN | wxFILE_MUST_EXIST);
	if(dlg.ShowModal() == wxID_OK)
	{
		std::string path = (const char*)dlg.GetDirectory().c_str();
		m_pFaceView->loadFDP((const char*)dlg.GetFilename().c_str(), path + std::string("/"));
	}
}

void wxFacePlayerFrame::OnStartPlayback(wxCommandEvent& event)
{
	m_pFaceView->startPlayback();
}

void wxFacePlayerFrame::OnStopPlayback(wxCommandEvent& event)
{
	m_pFaceView->stopPlayback();
}

void wxFacePlayerFrame::OnSlider(wxScrollEvent& event)
{
	m_pFaceView->jumpToFap(event.GetPosition());
}

void wxFacePlayerFrame::OnSoundOn(wxCommandEvent& event)
{
	m_pFaceView->muteSound(event.IsChecked());
}

void wxFacePlayerFrame::OnServerMode(wxCommandEvent& event)
{
	m_pFaceView->serverMode(event.IsChecked());
}

void wxFacePlayerFrame::StartServer()
{
	if(m_pFaceView->serverMode(true))
	{
		wxCustomButton* p = wxDynamicCast(wxWindow::FindWindowById(Listen_TCP, this), wxCustomButton);
		if(p)
			p->SetValue(true);
		else
		{
			wxToggleButton* p2 = wxDynamicCast(wxWindow::FindWindowById(Listen_TCP, this), wxToggleButton);
			if(p2)
				p2->SetValue(true);
		}
	}
}

void wxFacePlayerFrame::OnSaveAVI(wxCommandEvent& event)
{
	wxFileDialog dlg(this, _T("Save as AVI"), wxEmptyString, wxEmptyString, _T("AVI files (*.avi)|*.avi"),
		wxSAVE | wxOVERWRITE_PROMPT);
	if(dlg.ShowModal() == wxID_OK)
	{
	//	HideControls();
		// save the avi
		wxFileName fname(dlg.GetPath());
		fname.ClearExt();
		m_pFaceView->saveAVI((const char*)fname.GetFullPath().c_str());
	//	HideControls();
	}
}

void wxFacePlayerFrame::OnPortSettings(wxCommandEvent& event)
{
	ConnPortSetting dlg(this, m_pFaceView->getListeningPort());
	if (dlg.ShowModal() == wxID_OK)
		m_pFaceView->setListeningPort(dlg.getPort());
}

void wxFacePlayerFrame::OnBackgroundColor(wxCommandEvent& event)
{
	wxColourDialog dlg(this);
	if(dlg.ShowModal() == wxID_OK)
		m_pFaceView->setBackgroundColour(dlg.GetColourData().GetColour());
}

